#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from AddOneNotificationLetter import AssignOneClinicNotificationLetter

def AssignNotificationLetter(VistA):
  for MedicalCenter in ["Medical Center Primary Care",
                        "Mental Health",
                        "Orthopedics",
                        "OutPatient Primary Care",
                        "Audiology"]:
    AssignOneClinicNotificationLetter(VistA, "ZZAPPTCANCELLED",
                                      "APPT. CANCELLATION LETTER",
                                      MedicalCenter)

    AssignOneClinicNotificationLetter(VistA, "ZZCLINICCANCELLED",
                                      "CLINIC CANCELLATION LETTER",
                                      MedicalCenter)

    AssignOneClinicNotificationLetter(VistA, "ZZNOSHOW",
                                      "NO SHOW LETTER",
                                      MedicalCenter)

    AssignOneClinicNotificationLetter(VistA, "ZZPREAPPT",
                                      "PRE-APPOINTMENT LETTER",
                                      MedicalCenter)
